function [colProblem, rowProblem, xyzProblem] = checkRowCol(Data, checkVec)
% This function checks for NAN rows and columns. Furthermore data must have
% x-y-z format (dividable by three). Otherwise an errow will appear!

colProblem = 0;
rowProblem = 0; % Initialize with "no problems found"
xyzProblem = 0;


if checkVec(1) == 1 % check for Nan columns
    nr_columns_only_nan = sum(sum(isnan(Data),1) == size(Data,1));
    if nr_columns_only_nan ~= 0
        colProblem = 1;
        nums_sd = 1:size(Data, 2);
        cols_nan = nums_sd(sum(isnan(Data),1) == size(Data,1)); % compares if number of NaN (not a number) in a column equals row number
        
        fprintf('\n         There are %d columns with only NaNs (Cols %s)! Gap filling requires at least one entry per row and column!', nr_columns_only_nan, num2str(cols_nan))
%         warndlg('ATTENTION: Gap-filling selected - but columns with only NaN  (gaps or not a number) in data! Gap-filling requires at least one entry per row and column!')
%         error('ERROR found in PManalyzer computation: Gap-filling selected - but columns with only NaN (gaps or not a number) in data! Gap-filling requires at least one entry per row and column!')
        %                         Data = Data(:,sum(isnan(Data),1) ~=size(Data,1),:); %activate to cut outthese columns automatically
    else
        fprintf('\n         There are no columns with only NaNs!')
    end
end


if checkVec(2) == 1 % check for Nan rows
    
    nr_rows_only_nan = sum(sum(isnan(Data),2) == size(Data,2));
    if nr_rows_only_nan ~= 0
        rowProblem = 1;
        nums_sd = 1:size(Data, 1);
        rows_nan = nums_sd(sum(isnan(Data),1) == size(Data,2)); % compares if number of NaN (not a number) in a row equals column number
        fprintf('\n         There are %d rows    with only NaNs (Rows %s)!', nr_rows_only_nan, num2str(rows_nan))
    else
        fprintf('\n         There are no rows    with only NaNs!')
    end
    
end


if checkVec(3) == 1 % check for column size not dividable by 3
    colsPostProcessing = size( Data,2);
    if mod(colsPostProcessing, 3) ~= 0 % Safety if columns not dividable by three! (Expectation: x,y,z of each coordinate after readin!!!)
        xyzProblem = 1;
        fprintf('\n         ATTENTION: Columns of data set is not dividable by three!(Double check pre-processing options. Delete only unwanted columns (such as time-frames, etc.).\n\n')
%         warndlg('ATTENTION: The columns of at least one data set is not dividable by three! PCA-gap-filling requires x-y-z of each marker exclusively. Use pre-processing steps to delete unwanted columns (such as time-frames, etc.).')
%         error('ERROR found in PManalyzer computation: Gap-filling selected - but number of columns after pre-processign not dividable by three! Gapfilling requires x-y-z of each marker exclusively')
    end
end



% % % % %         % Enable following code to save data that does not correspond to the expected
% % % % %         % row-column format (data saved in subfolder "Suspect data")
% % % % %          path_save_data = '';
% % % % %         if size(Data,1) ~= rows_should_have || size(Data,2) ~= columns_should_have || nr_rows_only_nan ~= 0 || nr_columns_only_nan  ~= 0
% % % % %             A = exist([path_save_data, '\Suspect data'], 'dir');
% % % % %             if A == 7
% % % % %             else
% % % % %                 mkdir([path_save_data,'\Suspect data'])
% % % % %             end
% % % % %             save([path_save_data, '\Suspect data\Suspect_Data_Subject ',num2str(SubjNow), ' - Trial ',num2str(TrialNow)],'Data')
% % % % %         end

% % % % %         if size(Data,1) ~= rows_should_have && size(Data,2) ~= columns_should_have
% % % % %             fprintf('      Matrix saved as "Suspect_data" in matlab environment, since nr_rows and nr_columns are not as expected\n')
% % % % %         elseif size(Data,1) ~= rows_should_have
% % % % %             fprintf('      Matrix saved as "Suspect_data" in matlab environment, since nr_rows is not as expected\n')
% % % % %         elseif size(Data,2) ~= columns_should_have
% % % % %             fprintf('      Matrix saved as "Suspect_data" in matlab environment, since nr_columns is not as expected\n')
% % % % %         end


end